/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.clike.CLikeAvoidUnusedPrivateFieldsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.filter.JavaAnnotatedEntityFilter;
import eu.cqse.check.framework.util.filter.JavaLombokUnusedEntityFilter;
import eu.cqse.check.framework.util.filter.JavaSuppressWarningsUnusuedEntityFilter;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-java-avoid-unused-private-fields", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class JavaAvoidUnusedPrivateFieldsCheck
extends CLikeAvoidUnusedPrivateFieldsCheckBase {
    @CheckOption(name="Java annotations for unused private fields", description="List of Java annotations to exclude class fields from being reported as unused.")
    private Set<String> annotations = CollectionUtils.asHashSet((Object[])new String[]{"AConQATFieldParameter", "AConQATParameterObject", "CheckOption", "JsonProperty"});
    private static final String CHECK_OPTION_NAME = "Java annotations for unused private fields";
    private static final String CHECK_OPTION_DESCRIPTION = "List of Java annotations to exclude class fields from being reported as unused.";
    private JavaAnnotatedEntityFilter annotatedFieldFilter;

    public JavaAvoidUnusedPrivateFieldsCheck() {
        super((CLikeLanguageFeatureParserBase)LanguageFeatureParser.JAVA);
    }

    public void initialize() throws CheckException {
        super.initialize();
        this.annotatedFieldFilter = new JavaAnnotatedEntityFilter();
        this.annotatedFieldFilter.addAnnotations(this.annotations);
    }

    @Override
    protected boolean isFiltered(ShallowEntity field) {
        boolean containsSuppressAnnotations = JavaSuppressWarningsUnusuedEntityFilter.isFiltered((ShallowEntity)field);
        boolean containsLombokAnnotations = JavaLombokUnusedEntityFilter.isFiltered((ShallowEntity)field);
        boolean containsCustomAnnotations = this.annotatedFieldFilter.isFiltered(field);
        return containsSuppressAnnotations || containsLombokAnnotations || containsCustomAnnotations;
    }

    @Override
    protected String getFieldSelectionXPath() {
        return "/TYPE/ATTRIBUTE[subtype('attribute') and modifiers('private') and not(name-matches('serialVersionUID') and tokens('static', 'final', 'long'))]";
    }

    @Override
    protected String getProcessedEntitiesXPath() {
        return "descendant::ATTRIBUTE | descendant::STATEMENT | descendant::META | descendant::META[subtype('case')] | descendant::TYPE[subtype('anonymous class')] | descendant::METHOD | /TYPE[subtype('record')]";
    }
}

