/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-public-class-attribute", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PublicClassAttributeCheck
extends CheckImplementationBase {
    public static final String CHECK_NAME = "Public class attribute";
    public static final String ALLOW_NON_STATIC_FIELDS_OPTION_NAME = "Allow non-static final fields";
    @CheckOption(name="Annotation filter for public fields", description="Attributes annotated with an annotation contained in this list will be ignored for the analysis. E.g.: @Inject, @Attribute")
    private List<String> filterAnnotationNameList = Arrays.asList("@Parameter", "@Inject", "@Rule", "@Mock", "@AOptionFieldDescription");
    @CheckOption(name="Allow non-static final fields", description="Access to non-static final fields can be allowed since they represent immutable state of an object. Note that objects such as collections stored in a final field may still be modifiable by exposing them.")
    private boolean allowNonStaticFinalFields = false;
    private Set<String> filterAnnotationNames;

    public void initialize() {
        this.filterAnnotationNames = new HashSet<String>();
        for (String filterAnnotationName : this.filterAnnotationNameList) {
            this.filterAnnotationNames.add(StringUtils.stripPrefix((String)filterAnnotationName, (String)"@"));
        }
    }

    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.PUBLIC) || this.allowNonStaticFinalFields && TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.FINAL) || TokenStreamUtils.containsAll((List)attribute.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.FINAL}) || !TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.PUBLIC)) continue;
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (!this.isFilteredByAnnotation(entity)) {
            this.buildFinding("Non-constant public attribute `" + entity.getName() + "`", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private boolean isFilteredByAnnotation(ShallowEntity entity) {
        List annotations = LanguageFeatureParser.JAVA.getAnnotations(entity);
        return annotations.stream().anyMatch(annotation -> this.filterAnnotationNames.contains(annotation.getName()));
    }
}

