/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaStringValueResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpelExpressionCheckHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S6857", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SpelExpressionCheck
extends CheckImplementationBase {
    private JavaImportSensitiveTypeResolver typeResolver;
    private JavaStringValueResolver javaStringValueResolver;

    public void execute() throws CheckException {
        ShallowEntity root = this.context.getRootEntity(this.getCodeViewOption());
        this.typeResolver = new JavaImportSensitiveTypeResolver(root);
        this.javaStringValueResolver = new JavaStringValueResolver(root);
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)ast, Set.of(EShallowEntityType.META), Set.of("annotation")).stream().filter(this::isSpringAnnotation).forEach(this::checkAnnotationForSpelExpression);
    }

    private boolean isSpringAnnotation(ShallowEntity annotation) {
        String annotationName = annotation.getName();
        if (StringUtils.isEmpty((String)annotationName)) {
            return false;
        }
        return annotationName.startsWith("org.springframework") || this.typeResolver.getFullyQualifiedTypeName(annotationName).startsWith("org.springframework");
    }

    private void checkAnnotationForSpelExpression(ShallowEntity annotation) {
        TokenStreamUtils.splitWithNesting((List)LanguageFeatureParser.JAVA.getAnnotationParameterTokens(annotation), (ETokenType)ETokenType.COMMA, List.of(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK, ETokenType.LT), List.of(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK, ETokenType.GT)).forEach(parameter -> this.checkAnnotationParameterForSpelExpression(annotation, (List<IToken>)parameter));
    }

    private void checkAnnotationParameterForSpelExpression(ShallowEntity annotation, List<IToken> parameter) {
        List parameterValue = LanguageFeatureParser.JAVA.extractAnnotationParameterValue(parameter);
        if (parameterValue.isEmpty()) {
            return;
        }
        this.javaStringValueResolver.resolveStringExpression(parameterValue).flatMap(SpelExpressionCheck::checkSpelExpression).map(syntaxError -> this.buildFinding(syntaxError.getMessage(), this.buildLocation().forEntity(annotation))).ifPresent(CheckFindingBuilderBase::createAndStore);
    }

    private static Optional<SpelExpressionCheckHelper.SyntaxError> checkSpelExpression(String text) {
        try {
            SpelExpressionCheckHelper.validate(text);
            return Optional.empty();
        }
        catch (SpelExpressionCheckHelper.SyntaxError e) {
            return Optional.of(e);
        }
    }
}

