/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.matlab.MatlabCheckUtils;
import eu.cqse.check.matlab.MatlabFunctionDeclaration;
import eu.cqse.check.matlab.VariableUsageTracker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class MatlabDefUseCheckBase
extends CheckImplementationBase {
    private static final TokenPattern VARIABLE_ASSIGNMENT_AND_DEFINITION_PATTERN;
    protected static final EnumSet<ETokenType> NON_READ_PREDECESSOR_TOKENS;
    private static final Set<String> LOOP_TYPES;
    protected final Deque<VariableUsageTracker> scopeStack = new ArrayDeque<VariableUsageTracker>();

    public void execute() throws CheckException {
        this.checkBlock(this.context.getRootEntity(this.getCodeViewOption()));
    }

    private void checkBlock(ShallowEntity block) {
        this.openNewScope();
        if (EShallowEntityType.METHOD == block.getType()) {
            this.processMethodSignature(block);
        }
        for (ShallowEntity entity : block.getChildren()) {
            if (EShallowEntityType.TYPE == entity.getType() && entity.getSubtype().equals("class")) {
                List<ShallowEntity> methods = MatlabCheckUtils.getClassMethods(entity);
                for (ShallowEntity method : methods) {
                    this.checkBlock(method);
                }
                continue;
            }
            if (EShallowEntityType.METHOD == entity.getType() && EShallowEntityType.METHOD != block.getType()) {
                this.checkBlock(entity);
                continue;
            }
            this.checkEntity(entity);
        }
        this.createFindings();
        this.closeCurrentScope();
    }

    private void checkEntity(ShallowEntity entity) {
        if (EShallowEntityType.METHOD == entity.getType()) {
            this.processMethodSignature(entity);
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        List<IToken> readVariables = this.parseReads((List<IToken>)tokens);
        List<IToken> writtenVariables = this.parseAssignmentsAndDefinitions((List<IToken>)tokens);
        for (IToken writtenVariable : writtenVariables) {
            readVariables.removeIf(token -> token.getText().equals(writtenVariable.getText()));
        }
        readVariables.forEach(this::setVariableUsed);
        if (!LOOP_TYPES.contains(entity.getSubtype()) || !this.ignoreLoopOperator()) {
            writtenVariables.forEach(this::setVariableDeclared);
        }
        for (ShallowEntity childEntity : entity.getChildren()) {
            this.checkEntity(childEntity);
        }
    }

    private void processMethodSignature(ShallowEntity methodEntity) {
        List<IToken> functionDeclarationTokens = MatlabCheckUtils.getFunctionDeclarationTokens((List<IToken>)methodEntity.includedTokens(), 0);
        MatlabFunctionDeclaration declaration = MatlabFunctionDeclaration.of(functionDeclarationTokens);
        if (declaration != null) {
            declaration.getFunctionInputTokens().forEach(this::setVariableDeclared);
            declaration.getFunctionOutputTokens().forEach(this::setVariableUsed);
        }
    }

    protected List<IToken> parseReads(List<IToken> tokens) {
        List matches = new TokenPattern().notPrecededBy(NON_READ_PREDECESSOR_TOKENS).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).notFollowedBy((Object)ETokenType.LPAREN).findAll(tokens);
        return TokenPatternMatch.getAllTokens((List)matches, (int)0);
    }

    @VisibleForTesting
    public List<IToken> parseAssignmentsAndDefinitions(List<IToken> tokens) {
        TokenPatternMatch match = VARIABLE_ASSIGNMENT_AND_DEFINITION_PATTERN.findFirstMatch(tokens);
        if (match == null) {
            return new ArrayList<IToken>();
        }
        return TokenPatternMatch.getAllTokens(List.of(match), (int)0).stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).toList();
    }

    private void setVariableUsed(IToken variableToken) {
        this.scopeStack.getLast().setVariableUsed(variableToken);
    }

    private void setVariableDeclared(IToken variableToken) {
        this.scopeStack.getLast().setVariableDeclared(variableToken);
    }

    private void openNewScope() {
        this.scopeStack.addLast(new VariableUsageTracker());
    }

    private void closeCurrentScope() {
        CCSMAssert.isTrue((!this.scopeStack.isEmpty() ? 1 : 0) != 0, (String)"The scopeStack should not be empty");
        this.scopeStack.pollLast();
    }

    protected abstract void createFindings();

    protected abstract boolean ignoreLoopOperator();

    static {
        TokenPattern baseVariable = new TokenPattern().alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.COMP});
        TokenPattern memberAccess = new TokenPattern().sequence(new Object[]{ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true);
        TokenPattern structuredVariable = new TokenPattern().sequence(new Object[]{baseVariable}).group(0).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).repeated(new Object[]{memberAccess});
        TokenPattern bracketedVariableList = new TokenPattern().sequence(new Object[]{ETokenType.LBRACK}).sequence(new Object[]{structuredVariable}).repeated(new Object[]{ETokenType.ARRAY_SEPARATOR, structuredVariable}).sequence(new Object[]{ETokenType.RBRACK});
        TokenPattern variableAssignment = new TokenPattern().alternative(new Object[]{bracketedVariableList, structuredVariable}).sequence(new Object[]{ETokenType.EQ});
        TokenPattern variableDefinition = new TokenPattern().alternative(new Object[]{ETokenType.GLOBAL, ETokenType.PERSISTENT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
        VARIABLE_ASSIGNMENT_AND_DEFINITION_PATTERN = new TokenPattern().alternative(new Object[]{variableAssignment, variableDefinition});
        NON_READ_PREDECESSOR_TOKENS = EnumSet.of(ETokenType.DOT, ETokenType.GLOBAL, ETokenType.PERSISTENT);
        LOOP_TYPES = CollectionUtils.asHashSet((Object[])new String[]{"for", "parfor"});
    }
}

