/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.matlab.MatlabCheckUtils;
import eu.cqse.check.matlab.MatlabFunctionDeclaration;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-matlab-function-parameter-count", languages={ELanguage.MATLAB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MatlabFunctionParameterCountCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Methods should not have too many parameters (Matlab)";
    @CheckOption(name="Methods should not have too many parameters (Matlab): max. parameters", description="Maximum parameter count")
    private int maxNumberOfAllowedParameters = 7;

    private int getMaximumAllowedParameterCount() {
        return this.maxNumberOfAllowedParameters;
    }

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processEntity(method);
        }
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        List<IToken> functionDeclarationTokens = MatlabCheckUtils.getFunctionDeclarationTokens((List<IToken>)entity.includedTokens(), 0);
        MatlabFunctionDeclaration declaration = MatlabFunctionDeclaration.of(functionDeclarationTokens);
        if (declaration != null && declaration.getFunctionInputTokens().size() > this.getMaximumAllowedParameterCount()) {
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

