/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.matlab.MatlabDefUseCheckBase;
import eu.cqse.check.matlab.VariableUsageTracker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Check(id="cqse-matlab-used-but-undeclared-vars", languages={ELanguage.MATLAB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MatlabUsedButUndeclaredVarCheck
extends MatlabDefUseCheckBase {
    @CheckOption(name="Ignored MATLAB built-ins", description="List of MATLAB built-in constants, functions, and special variables that should not be flagged as undeclared variables. This typically includes constants like 'pi', special variables like 'ans', and parameterless functions like 'tic'.")
    private Set<String> ignoredBuiltInNames = new HashSet<String>(Arrays.asList("pi", "inf", "NaN", "eps", "realmax", "realmin", "i", "j", "true", "false", "nargin", "nargout", "varargin", "varargout", "ans", "computer", "version", "matlabroot", "pathsep", "tic", "toc", "cputime", "lasterr", "lastwarn", "gca", "gcf"));

    @Override
    protected void createFindings() {
        for (IToken token : ((VariableUsageTracker)this.scopeStack.getLast()).getUsedButUndeclaredVariables()) {
            if (this.ignoredBuiltInNames.contains(token.getText())) continue;
            this.buildFinding("Used but undeclared variable: " + token.getText(), this.buildLocation().forToken(token)).createAndStore();
        }
    }

    @Override
    protected boolean ignoreLoopOperator() {
        return false;
    }
}

