/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.ESimulinkNameCheckType;
import eu.cqse.check.simulink.SimulinkNameChecker;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;

@Check(id="cqse.jmaab.jc_0222", languages={ELanguage.SIMULINK})
public class SimulinkDiscouragedCharactersInSignalAndBusNamesCheck
extends CheckImplementationBase {
    @CheckOption(name="Disallow non-alphanumeric characters in signal and bus names", description="If set, signal and bus names that do not consist of single-byte alphanumeric characters (a-z, A-Z, 0-9) are disallowed.")
    private boolean disallowNonAlphanumericCharacters = true;
    @CheckOption(name="Disallow leading numbers in signal and bus names", description="If set, signal and bus names starting with digits are disallowed.")
    private boolean disallowStartWithNumbers = true;
    @CheckOption(name="Disallow consecutive underscores in signal and bus names", description="If set, signal and bus names with consecutive underscores (e.g. '__') are disallowed.")
    private boolean disallowConsecutiveUnderscores = true;
    @CheckOption(name="Disallow leading underscores in signal and bus names", description="If set, signal and bus names starting with underscores are disallowed.")
    private boolean disallowStartWithUnderscore = true;
    @CheckOption(name="Disallow trailing underscores in signal and bus names", description="If set, signal and bus names ending with underscores are disallowed.")
    private boolean disallowEndWithUnderscore = true;
    @CheckOption(name="Disallow signal and bus names as reserved MATLAB keywords", description="If set, signal and bus names matching reserved MATLAB keywords are disallowed.")
    private boolean disallowReservedMatlabKeyword = true;
    @CheckOption(name="Disallow signal and bus names as MATLAB function names", description="If set, signal and bus names matching MATLAB function names are disallowed.")
    private boolean disallowMatlabFunctionName = true;
    @CheckOption(name="Whitelisted signal and bus names", description="List of all signal and bus names that are explicitly allowed, separated by a comma. These names are ignored by this check.")
    private String whitelistedNames = "";
    private static final String FINDING_MESSAGE_ALPHANUMERIC_CHARACTER_USAGE = "Signal or bus name name shall contain only letters, digits, and underscores";
    private static final FindingPropertyList RECOMMENDED_ACTION_ALPHANUMERIC_CHARACTER_USAGE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the signal or bus name to only contain alphanumeric characters and underscores.");
    private static final String FINDING_MESSAGE_STARTS_WITH_NUMBER = "Signal or bus name name starts with a digit";
    private static final String FINDING_MESSAGE_STARTS_WITH_UNDERSCORE = "Signal or bus name starts with an underscore";
    private static final FindingPropertyList RECOMMENDED_ACTION_STARTS_WITH = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the signal or bus name to only use alphabetic characters at the beginning.");
    private static final String FINDING_MESSAGE_ENDS_WITH_UNDERSCORE = "Signal or bus name ends with an underscore";
    private static final FindingPropertyList RECOMMENDED_ACTION_ENDS_WITH_UNDERSCORE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the signal or bus name to not end with an underscore.");
    private static final String FINDING_MESSAGE_CONTAINS_CONSECUTIVE_UNDERSCORES = "Signal or bus name contains consecutive underscores";
    private static final FindingPropertyList RECOMMENDED_ACTION_CONTAINS_CONSECUTIVE_UNDERSCORES = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the signal or bus name to not use consecutive underscores.");
    private static final String FINDING_MESSAGE_RESERVED_KEYWORD = "Signal or bus name is a reserved MATLAB keyword";
    private static final String FINDING_MESSAGE_FUNCTION_NAME = "Signal or bus name is a MATLAB function name";
    private static final FindingPropertyList RECOMMENDED_ACTION_RESERVED_KEYWORD = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the signal or bus name to not use a reserved keyword as the parameter name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_FUNCTION_NAME = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the signal or bus name to not use a MATLAB function name as the parameter name.");

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(model -> {
            for (SimulinkLine line : model.getContainedLinesRecursively(false, false)) {
                if (SimulinkDiscouragedCharactersInSignalAndBusNamesCheck.isIgnoredLine(line)) continue;
                line.getName().ifPresent(name -> this.checkIfNameIsValid(line, (String)name));
            }
        });
    }

    private static boolean isIgnoredLine(SimulinkLine line) {
        SimulinkOutPort srcPort = line.getSrcPort();
        if (srcPort == null) {
            return false;
        }
        SimulinkBlock srcBlock = srcPort.getBlock();
        return "BusSelector".equals(srcBlock.getType()) && line.getName().filter(name -> name.startsWith("<")).isPresent();
    }

    private void checkIfNameIsValid(SimulinkLine line, String name) {
        Set<ESimulinkNameCheckType> typesToCheck = SimulinkNameChecker.createTypesToCheckSetFromConfigurations(this.disallowNonAlphanumericCharacters, this.disallowStartWithNumbers, this.disallowConsecutiveUnderscores, this.disallowStartWithUnderscore, this.disallowEndWithUnderscore, this.disallowReservedMatlabKeyword, this.disallowMatlabFunctionName);
        List<ESimulinkNameCheckType> failedChecks = SimulinkNameChecker.checkName(name, typesToCheck, this.whitelistedNames);
        for (ESimulinkNameCheckType failedCheck : failedChecks) {
            this.createFindingFromNameCheckType(failedCheck, line);
        }
    }

    private void createFindingFromNameCheckType(ESimulinkNameCheckType checkType, SimulinkLine line) {
        switch (checkType) {
            case ALPHANUMERIC_CHARACTER_USAGE: {
                this.buildFinding(FINDING_MESSAGE_ALPHANUMERIC_CHARACTER_USAGE, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_ALPHANUMERIC_CHARACTER_USAGE).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_NUMBER: {
                this.buildFinding(FINDING_MESSAGE_STARTS_WITH_NUMBER, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_STARTS_WITH).createAndStore();
                break;
            }
            case NAME_STARTS_WITH_UNDERSCORE: {
                this.buildFinding(FINDING_MESSAGE_STARTS_WITH_UNDERSCORE, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_STARTS_WITH).createAndStore();
                break;
            }
            case NAME_ENDS_WITH_UNDERSCORE: {
                this.buildFinding(FINDING_MESSAGE_ENDS_WITH_UNDERSCORE, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_ENDS_WITH_UNDERSCORE).createAndStore();
                break;
            }
            case CONSECUTIVE_UNDERSCORES_USAGE: {
                this.buildFinding(FINDING_MESSAGE_CONTAINS_CONSECUTIVE_UNDERSCORES, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_CONTAINS_CONSECUTIVE_UNDERSCORES).createAndStore();
                break;
            }
            case NAME_IS_MATLAB_FUNCTION_NAME: {
                this.buildFinding(FINDING_MESSAGE_FUNCTION_NAME, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_FUNCTION_NAME).createAndStore();
                break;
            }
            case NAME_IS_RESERVED_MATLAB_KEYWORD: {
                this.buildFinding(FINDING_MESSAGE_RESERVED_KEYWORD, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_RESERVED_KEYWORD).createAndStore();
                break;
            }
        }
    }
}

