/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.simulink.stateflow_data_typing.StateflowVariableTypeExtractor;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.hisf_0065", languages={ELanguage.SIMULINK})
public class SimulinkStateflowAssignmentOperatorCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider replacing the '=' operator with ':=' when using Stateflow objects.");
    private static final TokenPattern OPERAND_PATTERN = new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL)});
    private static final TokenPattern OPERATOR_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.PLUS, ETokenType.MINUS, ETokenType.MULT, ETokenType.DIV)}), new TokenPattern().sequence(new Object[]{ETokenType.MOD, ETokenType.MOD})});
    private static final TokenPattern UNARY_EXPRESSION_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.PLUS, ETokenType.PLUS, ETokenType.IDENTIFIER}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.PLUS, ETokenType.PLUS}), new TokenPattern().sequence(new Object[]{ETokenType.MINUS, ETokenType.MINUS, ETokenType.IDENTIFIER}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.MINUS, ETokenType.MINUS})});
    private static final TokenPattern ARITHMETIC_EXPRESSION_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{OPERAND_PATTERN, OPERATOR_PATTERN, OPERAND_PATTERN}), new TokenPattern().sequence(new Object[]{OPERAND_PATTERN, OPERATOR_PATTERN, ETokenType.LPAREN}), new TokenPattern().sequence(new Object[]{ETokenType.RPAREN, OPERATOR_PATTERN, OPERAND_PATTERN}), new TokenPattern().sequence(new Object[]{ETokenType.RPAREN, OPERATOR_PATTERN, ETokenType.LPAREN}), new TokenPattern().sequence(new Object[]{UNARY_EXPRESSION_PATTERN})});
    private static final double MAX_32_BIT_NUMBER = Math.pow(2.0, 32.0) - 1.0;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes signalTypeResolution = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || signalTypeResolution == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            StateflowBlock stateflowBlock;
            StateflowChart chart;
            String actionLanguage;
            if (!(block instanceof StateflowBlock) || "2".equals(actionLanguage = (chart = (stateflowBlock = (StateflowBlock)block).getChart()).getParameter("actionLanguage"))) continue;
            this.checkStateflowChart(chart, signalTypeResolution);
        }
    }

    private void checkStateflowChart(StateflowChart chart, SimulinkResolvedDataTypes signalTypeResolution) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            if (!(node instanceof StateflowState)) continue;
            StateflowState stateflowState = (StateflowState)node;
            List stateflowStateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)stateflowState);
            for (StateflowStateAction stateflowStateAction : stateflowStateActions) {
                this.checkCScript(stateflowStateAction.actionCode, stateflowState, signalTypeResolution);
            }
        }
    }

    private void checkCScript(List<IToken> codeTokens, StateflowState stateflowState, SimulinkResolvedDataTypes signalTypeResolution) {
        List indicesOfEquality = TokenStreamUtils.findAll(codeTokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.EQ}));
        StateflowVariableTypeExtractor variableTypeExtractor = new StateflowVariableTypeExtractor(signalTypeResolution);
        Iterator iterator = indicesOfEquality.iterator();
        while (iterator.hasNext()) {
            int indexOfEqualityOperator = (Integer)iterator.next();
            int endOfStatement = TokenStreamUtils.firstTokenMatching(codeTokens, (int)indexOfEqualityOperator, (ITokenMatcher)ETokenType.SEMICOLON);
            if (endOfStatement == -1) {
                endOfStatement = codeTokens.size();
            }
            CCSMAssert.isTrue((endOfStatement != 1 ? 1 : 0) != 0, (String)"Statements in Chart C language script are not delimited by semicolons.");
            if (!SimulinkStateflowAssignmentOperatorCheck.isArithmeticExpression(codeTokens, indexOfEqualityOperator, endOfStatement) || SimulinkStateflowAssignmentOperatorCheck.equalityOperatorNotPreceededByIdentifier(codeTokens, indexOfEqualityOperator)) continue;
            this.checkForAssignmentToWiderDataType(codeTokens, stateflowState, variableTypeExtractor, indexOfEqualityOperator, endOfStatement, codeTokens.get(indexOfEqualityOperator - 1));
        }
    }

    private static boolean equalityOperatorNotPreceededByIdentifier(List<IToken> codeTokens, int indexOfEqualityOperator) {
        int indexOfPreviousToken = indexOfEqualityOperator - 1;
        if (indexOfPreviousToken < 0) {
            return false;
        }
        return codeTokens.get(indexOfPreviousToken).getType() != ETokenType.IDENTIFIER;
    }

    private void checkForAssignmentToWiderDataType(List<IToken> codeTokens, StateflowState stateflowState, StateflowVariableTypeExtractor variableTypeExtractor, int indexOfEqualityOperator, int indexOfSemicolon, IToken assignmentVariableToken) {
        String assignmentVariableDataType = variableTypeExtractor.determineType(assignmentVariableToken.getText(), (StateflowDeclContainerBase)stateflowState);
        String dataTypeFromRightHandSide = SimulinkStateflowAssignmentOperatorCheck.resolveDataTypeOfOperands(codeTokens.subList(indexOfEqualityOperator + 1, indexOfSemicolon), variableTypeExtractor, stateflowState);
        if (assignmentVariableDataType == null || "Unknown".equals(assignmentVariableDataType) || "NOT_CONNECTED".equals(assignmentVariableDataType)) {
            return;
        }
        if (SimulinkStateflowAssignmentOperatorCheck.getBitCountOfDataType(assignmentVariableDataType) > SimulinkStateflowAssignmentOperatorCheck.getBitCountOfDataType(dataTypeFromRightHandSide)) {
            String commandExpression = SimulinkStateflowAssignmentOperatorCheck.extractCommandExpression(indexOfEqualityOperator - 1, codeTokens);
            this.buildFinding("Assignment operator '=' is used in Stateflow object: " + commandExpression, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)stateflowState)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static String resolveDataTypeOfOperands(List<IToken> codeTokens, StateflowVariableTypeExtractor variableTypeExtractor, StateflowState stateflowState) {
        if (TokenStreamUtils.contains(codeTokens, (ETokenType)ETokenType.DIV)) {
            return "double";
        }
        List variableTokensIndices = TokenStreamUtils.findAll(codeTokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        if (variableTokensIndices.isEmpty()) {
            return SimulinkStateflowAssignmentOperatorCheck.getWidestNumericDataType(codeTokens);
        }
        return SimulinkStateflowAssignmentOperatorCheck.resolveDataTypeOfIdentifierOperands(codeTokens, variableTypeExtractor, stateflowState, variableTokensIndices);
    }

    private static String resolveDataTypeOfIdentifierOperands(List<IToken> codeTokens, StateflowVariableTypeExtractor variableTypeExtractor, StateflowState stateflowState, List<Integer> variableTokensIndices) {
        String variableName;
        Iterator<Integer> variableTokenIndicesIterator = variableTokensIndices.iterator();
        String resultDataType = "Unknown";
        if (variableTokenIndicesIterator.hasNext()) {
            variableName = codeTokens.get(variableTokenIndicesIterator.next()).getText();
            resultDataType = variableTypeExtractor.determineType(variableName, (StateflowDeclContainerBase)stateflowState);
        }
        while (variableTokenIndicesIterator.hasNext()) {
            variableName = codeTokens.get(variableTokenIndicesIterator.next()).getText();
            String variableDataType = variableTypeExtractor.determineType(variableName, (StateflowDeclContainerBase)stateflowState);
            resultDataType = SimulinkStateflowAssignmentOperatorCheck.determineWiderDataType(resultDataType, variableDataType);
        }
        return resultDataType;
    }

    private static String getWidestNumericDataType(List<IToken> codeTokens) {
        Optional<String> optionalIntegerDataType = SimulinkStateflowAssignmentOperatorCheck.getWidestNumericDataType(codeTokens, ETokenType.FLOATING_POINT_LITERAL);
        return optionalIntegerDataType.orElseGet(() -> SimulinkStateflowAssignmentOperatorCheck.getWidestNumericDataType(codeTokens, ETokenType.INTEGER_LITERAL).orElse("Unknown"));
    }

    private static Optional<String> getWidestNumericDataType(List<IToken> codeTokens, ETokenType numericTypeToSearch) {
        List integerTokens = TokenStreamUtils.findAllTokens(codeTokens, (ITokenMatcher)numericTypeToSearch);
        if (integerTokens.isEmpty()) {
            return Optional.empty();
        }
        String dataType = "uint32";
        for (IToken token : integerTokens) {
            String newDataType = "uint32";
            if (Double.parseDouble(token.getText()) > MAX_32_BIT_NUMBER) {
                newDataType = "uint64";
            }
            dataType = SimulinkStateflowAssignmentOperatorCheck.determineWiderDataType(newDataType, dataType);
        }
        return Optional.of(dataType);
    }

    private static String determineWiderDataType(String firstDataType, String secondDataType) {
        if (firstDataType == null || secondDataType == null || "Unknown".equals(firstDataType) || "Unknown".equals(secondDataType)) {
            return "Unknown";
        }
        if ("NOT_CONNECTED".equals(firstDataType) || "NOT_CONNECTED".equals(secondDataType)) {
            return "NOT_CONNECTED";
        }
        if (SimulinkStateflowAssignmentOperatorCheck.getBitCountOfDataType(firstDataType) > SimulinkStateflowAssignmentOperatorCheck.getBitCountOfDataType(secondDataType)) {
            return firstDataType;
        }
        return secondDataType;
    }

    private static boolean isArithmeticExpression(List<IToken> codeTokens, int indexOfEqualityOperator, int endOfStatement) {
        return ARITHMETIC_EXPRESSION_PATTERN.findFirstMatch(codeTokens.subList(indexOfEqualityOperator + 1, endOfStatement)) != null;
    }

    private static int getBitCountForFixedDataType(String dataType) {
        String fixedDataTypeSpec = dataType.substring("fixdt".length() + 2, dataType.length() - 1);
        String[] specParts = fixedDataTypeSpec.split(",");
        if (specParts.length < 2) {
            return 0;
        }
        String wordLength = specParts[1];
        if (wordLength.matches("\\d+")) {
            return Integer.parseInt(wordLength);
        }
        return 0;
    }

    private static int getBitCountOfDataType(String dataType) {
        if (dataType.startsWith("fixdt")) {
            return SimulinkStateflowAssignmentOperatorCheck.getBitCountForFixedDataType(dataType);
        }
        switch (dataType) {
            case "int8": 
            case "uint8": {
                return 8;
            }
            case "int16": 
            case "uint16": 
            case "half": {
                return 16;
            }
            case "int32": 
            case "uint32": 
            case "single": {
                return 32;
            }
            case "int64": 
            case "uint64": 
            case "double": {
                return 64;
            }
        }
        return 0;
    }

    private static String extractCommandExpression(int startTokenIndex, List<IToken> tokens) {
        StringBuilder expressionBuilder = new StringBuilder();
        for (int tokenIndex = startTokenIndex; tokenIndex < tokens.size(); ++tokenIndex) {
            IToken currentToken = tokens.get(tokenIndex);
            expressionBuilder.append(currentToken.getText());
            if (currentToken.getType() == ETokenType.SEMICOLON) break;
        }
        return expressionBuilder.toString();
    }
}

