/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0731", languages={ELanguage.SIMULINK})
public class SimulinkStateflowStateNameFormatCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Stateflow state name %s ends with a /";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove / (slashes) at the end of the state name.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        StateflowMachine machine = model.getStateflowMachine();
        if (machine == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            this.checkChart(chart);
        }
    }

    private void checkChart(StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            if (!(node instanceof StateflowState)) continue;
            this.checkNodeName((StateflowState)node);
        }
    }

    private void checkNodeName(StateflowState node) {
        String name;
        String label = node.getLabel();
        if (label != null && (name = label.split("[\\\\][n]")[0]).endsWith("/")) {
            this.buildFinding(String.format(FINDING_MESSAGE, name), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)node)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

