/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.xml;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlCheckHandlerBase
extends DefaultHandler {
    private Locator locator;
    private final Set<XmlFinding> findings = new HashSet<XmlFinding>();

    public Set<XmlFinding> getFindings() {
        return this.findings;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected void createFinding(String message) {
        this.findings.add(new XmlFinding(this, message, this.locator.getLineNumber()));
    }

    protected void createElementFinding(String message) {
        this.findings.add(new XmlFinding(this, message, -1));
    }

    protected abstract void checkAttributes(Attributes var1);

    protected abstract void checkValue(String var1);

    class XmlFinding {
        public static final int FILE_LEVEL = -1;
        private final String message;
        private final int line;

        private XmlFinding(XmlCheckHandlerBase this$0, String message, int line) {
            this.message = message;
            this.line = line;
        }

        public String getMessage() {
            return this.message;
        }

        public int getLine() {
            return this.line;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.message);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            XmlFinding other = (XmlFinding)obj;
            return this.line == other.line && Objects.equals(this.message, other.message);
        }
    }
}

