# Rule 11.7 A cast shall not be performed between pointer to object and a non-integer arithmetic type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
For the purposes of this rule a non-integer arithmetic type means one of:
- *Essentially Boolean*;
- *Essentially character*;
- *Essentially enum*;
- *Essentially floating*.
## Rationale
Conversion of an *essentially Boolean*, *essentially character* or *essentially enum* type into a pointer to object may result in a pointer that is not correctly aligned, resulting in undefined behaviour.
Conversion of a pointer to object into an *essentially Boolean*, *essentially character* or *essentially enum* type may produce a value that cannot be represented in the chosen integer type resulting in undefined behaviour.
Conversion of a pointer to object into or from an *essentially floating* type results in undefined behaviour.
## Example
```c
int16_t *p;
float32_t f;

f = ( float32_t ) p; /* Non-compliant */
p = ( int16_t * ) f; /* Non-compliant */
```
## See also
Rule 11.4

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
