# Rule 13.4 The result of an assignment operator should not be used
## Category
Advisory
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
This rule applies even if the expression containing the assignment operator is not evaluated.
## Rationale
The use of assignment operators, simple or compound, in combination with other arithmetic operators is not recommended because:
- It can significantly impair the readability of the code;
- It introduces additional *side effects* into a statement making it more difficult to avoid the undefined behaviour covered by Rule 13.2.
## Example
```c
x = y; /* Compliant */
a[ x ] = a[ x = y ]; /* Non-compliant - the value of x = y
 * is used */

/*
 * Non-compliant - value of bool_var = false is used but
 * bool_var == false was probably intended
 */
if ( bool_var = false )
{
}

/* Non-compliant even though bool_var = true isn't evaluated */
if ( ( 0u == 0u ) || ( bool_var = true ) )
{
}

/* Non-compliant - value of x = f() is used */
if ( ( x = f ( ) ) != 0 )
{
}

/* Non-compliant - value of b += c is used */
a[ b += c ] = a[ b ];

/* Non-compliant - values of c = 0 and b = c = 0 are used */
a = b = c = 0;
```
## See also
Rule 13.2

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
