# Rule 16.3 Every *switch-clause* shall be appropriately terminated

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
Each *switch-clause*, or if the *switch-clause* is a compound statement each path through the *switch-clause*, shall be terminated by:
1. A *jump-statement* (i.e. a *goto* statement, a *break* statement, a *continue* statement, or a *return* statement), or
2. A call to a *_Noreturn*-qualified function.

*Note:* A *switch-clause* is defined as containing at least one statement. Two consecutive labels (whether *case* or *default-labels*), do not have an intervening statement and are therefore permitted by this rule.

## Rationale
If a developer fails to appropriately terminate a *switch-clause*, then control flow “falls” into the following *switch-clause* or, if there is no such clause, off the end and into the statement following the *switch* statement. An unterminated *switch-clause* occurring at the end of a *switch* statement may fall into any *switch-clauses* which are added later.

Whilst falling into a following *switch-clause* is sometimes intentional, it is often an error. Appropriate termination of each *switch-clause* ensures that such errors can be detected.

## Example
```c
switch ( x )
{
  case 0:
    break;            /* Compliant - unconditional break */
  case 1:             /* Compliant - empty fall through allows a group */
  case 2:
    break;            /* Compliant */
  case 4:
    a = b;            /* Non-compliant - break omitted */
  case 5:
    if ( a == b )
    {
      ++a;
      break;          /* Non-compliant - conditional break */
    }
  case 6:
    abort();          /* Compliant - abort is defined as _NoReturn */
                      /* - but violates R.21.8 */
  case 7:
    continue;         /* Compliant */
  default:
    ;                 /* Non-compliant - default must also be terminated */
}
```

## See also
Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - March 2025].