# Dir 4.10 Precautions shall be taken in order to prevent the contents of a header file being included more than once

## Category
Required

## Applies to
C90, C99, C11

## Amplification
Any identifier used to test and record whether a given *header file* has already been included shall be unique across all *header files* in the project.

## Rationale
When a translation unit contains a complex hierarchy of nested *header files*, it is possible for a particular *header file* to be included more than once. This can be, at best, a source of confusion. If this multiple inclusion leads to multiple or conflicting definitions, then this can result in undefined or erroneous behaviour.

## Example
```c
/* file.h */
#ifndef FILE_H
/* Non-compliant - does not #define FILE_H */
#endif
```

The following examples show two ways by which the contents of a header file could be protected from being included more than once in a translation unit, but this is not an exclusive list.

```c
<start-of-file>
#if !defined ( identifier )
#define identifier
  /* Contents of file */
#endif
<end-of-file>
```

```c
<start-of-file>
#ifndef identifier
#define identifier
  /* Contents of file */
#endif
<end-of-file>
```

## See also
Rule 5.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].