# Rule 14–5–2 (Required) A copy constructor shall be declared when there is a template constructor with a single parameter that is a generic parameter.

## Rationale
Contrary to possible developer expectations, a template constructor will not suppress the compiler generated copy constructor. This may lead to incorrect copy semantics for members requiring deep copies.

## Example
```c
class A 
{ 
public: 
 A ( ); 
 // A ( A const & rhs ); Example 1 - implicitly generated
 template <typename T> 
 A ( T const & rhs ) // Example 2 
 : i ( new int32_t ) 
 { 
 *i = *rhs.i; 
 }
private: 
 int32_t * i; // Member requires deep copy 
};
void f ( A const & a1 ) 
{ 
 A a2 ( a1 ); // Non-compliant - Unexpectedly uses Example 1 
}
```
The implicitly generated copy constructor, Example 1, will be used to construct a2 from a1.
Therefore, a shallow copy on the pointer member i will result in both a1.i and a2.i pointing to the same object. Was this the intent, or was it expected that a new object would be created and initialized?

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
