# Rule 16–1–2 (Required) All #else, #elif and #endif preprocessor directives shall reside in the same file as the #if or #ifdef directive to which they are related.

## Rationale
When the inclusion and exclusion of blocks of statements is controlled by a series of preprocessor directives, confusion can arise if all of the relevant directives do not occur within one file. This rule requires that all preprocessor directives in a sequence of the form #if / #ifdef ... #elif ... #else ... #endif shall reside in the same file. Observance of this rule preserves good code structure and avoids maintenance problems.
Notice that this does not preclude the possibility that such directives may exist within included files provided that all directives that relate to the same sequence are located in one file.

## Example
```c
// file.cpp 
#define A 
... 
#ifdef A 
... 
#include "file1.hpp" 
# 
#endif 
... 
#if 1 
#include "file2.hpp" 
...
// file1.hpp 
#if 1 
... 
#endif // Compliant
// file2.hpp 
... 
#endif // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
