# Rule 5–2–5 (Required) A cast shall not remove any const or volatile qualification from the type of a pointer or reference.

## Amplification
[Undefined 7.1.5.1(4, 7)]

## Rationale
Removal of the const or volatile qualification may not meet developer expectations as it may lead to undefined behaviour.

## Example
```c
void f ( const char_t * p ) 
{ 
 *const_cast< char_t * >( p ) = '\0'; // Non-compliant 
}
int main ( ) 
{ 
 f ( "Hello World!" ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
