# Rule 5–2–7 (Required) An object with pointer type shall not be converted to an unrelated pointer type, either directly or indirectly.

## Amplification
[Unspecified 5.2.10(7)]

## Rationale
The result of converting from a pointer to an unrelated type is unspecified.

## Example
```c
struct S 
{ 
 int32_t i; 
 int32_t j; 
};
class C 
{ 
public: 
 int32_t i; 
public: 
 int32_t j; 
 virtual ~C ( ); 
};
void f ( S * s ) 
{ 
 C * c = reinterpret_cast< C * >( s ); // Non-compliant 
 int32_t i = reinterpret_cast< int32_t >( s ); // Compliant, but 
 // breaks Rule 5–2–9 
 C * d = reinterpret_cast< C * >( i ); // Non-compliant 
 S * e = reinterpret_cast< S * >( i ); // Compliant, but 
 // breaks Rule 5–2–8 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
