# Rule 5–3–3 (Required) The unary & operator shall not be overloaded.

## Amplification
[Undefined 5.3.1(4)]

## Rationale
Taking the address of an object of incomplete type where the complete type contains a user declared operator & leads to undefined behaviour.

## Example
```c
// A.h 
class A 
{ 
public: 
 A * operator & ( ); // Non-compliant 
};
// f1.cc 
class A;
void f ( A & a ) 
{ 
 &a; // uses built-in operator & 
}
// f2.cc 
#include "A.h"
void f2 ( A & a ) 
{ 
 &a; // use user-defined operator & 
}
```

## See also
ISO/IEC 14882:2003 [1] §5.3.1(4)

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
