# Rule 19.0.3 #include directives should only be preceded by preprocessor directives or comments

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule shall be applied to the contents of a file before preprocessing occurs.

For purposes of this rule, the tokens used to open and close a *linkage-specification* are ignored.

## Rationale
To aid code readability, all of the `#include` directives in a particular code file should be grouped
together near the top of the file.

Additionally, using `#include` to include a *standard header file* within a declaration or definition, or
using part of the C++ Standard Library before the inclusion of the related *standard header file* results
in *undefined behaviour*.

## Example
```cpp
// f.h
xyz = 0;

// f.cpp
int16_t // No more includes allowed in f.cpp after this code
#include "f.h" // Non-compliant

// f1.cpp
#define F1_MACRO
#include "a.h" // Compliant

extern "C" // Linkage-specification tokens are ignored
{ // Linkage-specification token is ignored
 #include "b.h" // Compliant
} // Linkage-specification token is ignored

#include "c.h" // Compliant

extern "C" // Linkage-specification tokens are ignored
{ // Linkage-specification token is ignored
 #include "d.h" // Compliant
 void g(); // No more includes allowed in f1.cpp after this code
} // Linkage-specification token is ignored

#include "e.h" // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
