# Rule 8.14.1 The right-hand operand of a logical `&&` or `||` operator should not contain *persistent side effects*

## Category
Advisory

## Analysis
Undecidable, System

## Rationale
The evaluation of the right-hand operand of the `&&` and `||` operators is conditional on the value of the
left-hand operand. If the right-hand operand contains *side effects* then those *side effects* may or may
not occur, which may be contrary to developer expectations.

If evaluation of the right-hand operand would produce *side effects* which are not *persistent* at the point
in the program where the expression occurs then it does not matter whether the right-hand operand
is evaluated or not.

The term *persistent side effect* is defined in Appendix C.

## Example
```cpp
uint16_t f( uint16_t y ) // The side effects within f are not
{ // persistent, as seen by the caller
  uint16_t temp = y;
  temp = y + 0x8080U;
  return temp;
}

uint16_t h( uint16_t y )
{
  static uint16_t temp = 0;
  temp = y + temp; // This side effect is persistent
  return temp;
}

void g( bool ishigh )
{
  if ( ishigh && ( a == f( x ) ) ) // Compliant - f() has no persistent
  { // side effects
  }

  if ( ishigh && ( a == h( x ) ) ) // Non-compliant - h() has a persistent
  { // side effect
  }
}

volatile uint16_t v;
         uint16_t x;

if ( ( x == 0u ) || ( v == 1u ) ) // Non-compliant - access to volatile v
{ // is persistent
}

( fp != nullptr ) && ( *fp )( 0 ); // Non-compliant if fp points to a function
                                   // with persistent side effects

if ( fp != nullptr )
{
  ( *fp )( 0 ); // Compliant version of the above
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
