# Rule 1.4 Emergent language features shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
Updates to the C Standard have introduced new language features. The following shall not be used:
*   Other than defining `__STDC_WANT_LIB_EXT1__` to `0`, the facilities of Annex K (Bounds-checking interfaces) shall not be used.

## Rationale
Use of the language features restricted by this rule may have instances of undefined, unspecified or implementation-defined behaviour associated with them. In addition, features may also exhibit well-defined behaviour that does not meet developer expectations.

Any instances of undefined, unspecified or implementation-defined behaviour are diagnosed by:
*   Dir 1.1, which requires that the use of implementation-defined behaviour be documented and taken into consideration; and
*   Rule 1.3, which prohibits the presence of undefined and critical unspecified behaviours.

However, detection of these behaviours alone does not mitigate against well-defined behaviour that does not meet developer expectations. Additional static analysis checks are needed to check for these behaviours, but there is no requirement for a static analysis tool to implement these checks as they are not specified within The Guidelines.

This Rule requires that any use of an emergent language feature be supported by a deviation to ensure that all undesirable behaviours are identified and measures put in place to ensure that they do not compromise safety or security.

## See also
Dir 1.1, Rule 1.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].