# Rule 23.1 A generic selection should only be expanded from a macro

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
A generic selection expression should only be expanded from a function-like macro, with one of the macro’s arguments expanded into the controlling expression of the generic selection.

## Rationale
Generic selections are useful to implement type queries or checks, or generic functions. If the generic selection is applied directly rather than expanded from a macro body, the type of the operand is already known locally and querying it is not necessary.

## Example
The following example is non-compliant, as it is not a macro:
```c
int32_t x = 0;

/* Non-compliant - not a macro */
int32_t y = _Generic( x
                    , int32_t : 1
                    , float   : 2 );
```
The following example implements a regular generic function, and can be expanded into contexts where the operand type may vary:
```c
/* Compliant - used to implement a generic function */
#define arith(X) ( _Generic( (X)          \
                   , int32_t : handle_int32 \
                   , float   : handle_float \
                   , default : handle_any   ) (X) )
```
The following example is not compliant because it expands to a generic selection which does not depend on the type of an argument:
```c
/* Non-compliant */
#define maybe_inc(Y) ( _Generic( x \
                       , int32_t : 1 \
                       , default : 0 ) + (Y) )
```

## See also
Dir 4.9, Rule 13.6, Rule 23.2

---

Copyright The MISRA Consortium Limited © [Date - March 2025].