# Dir 4.7 If a function returns error information, then that error information shall be tested

## Category
Required

## Applies to
C90, C99, C11

## Amplification
The list of functions that are deemed to return error information shall be determined by the project.

The error information returned by a function shall be tested in a meaningful manner.

## Rationale
A function (whether it is part of the Standard Library, a third party library or a user defined function) may be deemed to provide some means of indicating the occurrence of an error. This may be via an error flag, some special return value or some other means. Whenever such a mechanism is provided by a function the calling program shall check for the indication of an error as soon as the function returns.

However, note that the checking of input values to functions is considered a more robust means of error prevention than trying to detect errors after the function has completed (see Dir 4.11).

## Exception
If it can be shown, for example by checking arguments, that a function cannot return an error indication then there is no need to perform a check.

## See also
Dir 4.11, Rule 17.7

---

Copyright The MISRA Consortium Limited © [Date - March 2025].