# Rule 19–3–1 (Required) The error indicator errno shall not be used.

## Category
Required

## Rationale
errno is a facility of C++ which should in theory be useful, but which in practice is poorly defined
by ISO/IEC 14882:2003 [1]. A non-zero value may or may not indicate that a problem has occurred;
therefore errno shall not be used.
Even for those functions for which the behaviour of errno is well defined, it is preferable to check
the values of inputs before calling the function rather than relying on using errno to trap errors.

## Example
```cpp
#include <cstdlib> 
#include <cerrno>
void f1 ( const char_t * str ) 
{ 
 errno = 0; // Non-compliant 
 int32_t i = atoi ( str );
 if ( 0 != errno ) // Non-compliant 
 { 
 // handle error case??? 
 } 
}
```

## See also
Rule 0–3–2

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
