# Rule 5–2–11 (Required) The comma operator, && operator and the || operator shall not be overloaded.

## Rationale
Overloaded versions of the comma and logical conjunction operators have the semantics of function calls whose sequence point and ordering semantics are different from those of the built-in versions. It may not be clear at the point of use that these operators are overloaded, and so developers may be unaware which semantics apply.

## Example
```c
#include "util.h"
class A 
{ 
public: 
 UtilType getValue ( ); 
 UtilType setValue ( UtilType const & ); 
};
void f1 ( A & a1, A & a2 ) 
{ 
 a1.getValue ( ) && a2.setValue ( 0 ); // Short circuiting may occur 
}
bool operator && ( UtilType const &, 
 UtilType const & ); // Non-compliant
void f2 ( A & a1, A & a2 ) 
{ 
 a1.getValue ( ) && a2.setValue ( 0 ); // Both operands evaluated 
}
```
If the type returned by getValue and setValue has an overloaded operator &&, then both getValue and setValue will be evaluated.

## See also
ISO/IEC 14882:2003 [1] §5.14, §5.15, §5.18

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
