# Rule 5–2–6 (Required) A cast shall not convert a pointer to a function to any other pointer type, including a pointer to function type.

## Amplification
[Undefined 5.2.10(6), Unspecified 5.2.10(6)]

## Rationale
Conversion of a function pointer to a non-function pointer type causes undefined behaviour.
Undefined behaviour may arise if a function call is made using a pointer that is the result of a function pointer conversion.

## Example
```c
void f ( int32_t ) 
{ 
 reinterpret_cast< void (*)( ) >( &f ); // Non-compliant 
 reinterpret_cast< void * >( &f ); // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
