# Rule 0.2.2 A named function parameter shall be *used* at least once

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule does not apply to parameters that are declared `[[maybe_unused]]`.

Note: this rule also applies to the parameters of a lambda.

## Rationale
It is expected that most functions will *use* their parameters. If a function parameter is *unused*, it is
possible that the implementation of the function may not satisfy its requirements. This rule helps to
highlight such potential mismatches.

In cases where an *unused* parameter is required, for example when defining a virtual function or a
*callback* function, the parameter can be left unnamed. Where the *use* of a parameter depends on the
expansion of a macro or varies between different template instantiations, then the parameter can be
declared `[[maybe_unused]]`.

## Example
```cpp
class B
{
public:
  virtual int16_t f( int16_t a, int16_t b );
};

class D1 : public B
{
public:
  int16_t f( int16_t a, int16_t b ) override // Non-compliant - 'b' unused
  {
    return a;
  }
};

class D2 : public B
{
public:
  int16_t f( int16_t a, // Compliant - 'a' is used
             int16_t ) override // Rule does not apply - unnamed parameter
  {
    return a;
  }
};

class D3 : public B
{
public:
  int16_t f( int16_t a, int16_t b ) override // Compliant
  {
    return a + b;
  }
};

class D4 : public B
{
public:
  int16_t f( int16_t a, // Compliant
             int16_t b [[maybe_unused]] ) override // Rule does not apply -
                                                   // declared [[maybe_unused]]
  {
    assert( b > 0 ); // assert macro may expand to nothing,
                     // leaving 'b' unused.
    return a;
  }
};

void f1(int32_t i, // Non-Compliant
        int32_t j ) // Compliant - explicitly cast to void
{
  ( void )j;

  auto l = []( int32_t m, // Compliant
               int32_t n ) // Non-compliant
  {
    return m;
  };
}

template< bool b >
int32_t f2( int32_t i, // Non-compliant for f2< false >
            int32_t j [[maybe_unused]] ) // Rule does not apply - [[maybe_unused]]
{
  if constexpr ( b )
  {
    return i + j;
  }

  return 0;
}
```

## See also
Rule 0.2.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
