# Rule 5.10.1 User-defined identifiers shall have an appropriate form

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
When introducing an identifier, it shall be formed according to the following rules:
1.  A *universal-character-name* used at the start of an identifier shall be:
    a.  In the range `[a-z]`, `[A-Z]` or `_` or
    b.  Within the character class *XID_Start*, as defined by the Unicode standard UAX #44 [13].
2.  A *universal-character-name* within an identifier shall be:
    a.  One of the characters allowed at the start of an identifier; or
    b.  Within the character class *XID_Continue*, as defined by the Unicode standard UAX #44 [13].
3.  All identifiers shall conform to *Normalization Form C*, as specified in ISO/IEC 10646 [7].
4.  An identifier shall not contain a double underscore `__`.
5.  An identifier that is not used as a literal suffix shall not start with `_`.
6.  A user-defined literal suffix shall start with a single `_` and shall not be preceded by a space.

A macro identifier shall additionally only be formed using characters in the ranges `[A-Z]`, `[0-9]` and `_`.

Other identifiers shall additionally:
1.  Not be defined in namespace `std`, `posix`, or `stdN`, where 'N' is any number; and
2.  Not appear in the list `defined`, `final`, `override`, `clock_t`, `div_t`, `FILE`, `fpos_t`, `lconv`,
    `ldiv_t`, `mbstate_t`, `ptrdiff_t`, `sig_atomic_t`, `size_t`, `time_t`, `tm`, `va_list`,
    `wctrans_t`, `wctype_t` or `wint_t`.

Note: this rule does not apply to template specializations, as they do not introduce new identifiers —
see [temp.expl.spec].

## Rationale
This rule prohibits the introduction of an identifier with a reserved name, and restricts the characters
permitted within identifiers to a subset of those that are currently permitted by the C++ Standard.
This subset is aligned with Unicode recommendations that are expected to be adopted in a future
revision of the C++ Standard.

For macro names, this rule further restricts the set of permitted characters for the following reasons:
1.  It enforces commonly accepted coding style;
2.  It helps distinguishing macros from other identifiers;
3.  It prevents collision with the name of an attribute defined within the C++ Standard or with any
    name defined in the C++ Standard Library, preventing *undefined behaviour* (even when the
    corresponding *header file* is not explicitly included);
4.  It prevents collision with keywords or alternative representations, preventing *undefined behaviour*.

The restrictions always prohibit the use of identifiers that are only prohibited by the C++ Standard
within certain contexts (and for which no diagnostic is required in some cases). This rule broadens
the context in which these identifiers are not acceptable in order to reduce the risk of confusion.

## Example
```cpp
int32_t i﴾ = 2; // Non-compliant - character \ufd3e (even though
                // it may compile)

#define identity(a) a // Non-compliant - shall be in uppercase

void f()
{
  auto _i = 0; // Non-compliant - using a leading _, even at
               // local scope, is prohibited
}

void operator ""_km( long double ); // Compliant - will be called for 1.0_km
void operator ""mil( long double ); // Non-compliant - user-defined literal
                                    // suffixes shall start with _

double operator ""_Bq ( long double ); // Compliant
double operator "" _Bq( long double ); // Non-compliant - _Bq is preceded by a
                                       // space, making it a reserved identifier

namespace std42
{
  inline namespace a
  {
    int i; // Non-compliant - defined within namespace stdN
  }
}

auto final = 42; // Non-compliant

#include <cstdio> // Compliant - even though it introduces FILE

namespace std
{
  template <> struct hash< A > // Rule does not apply
  {
    size_t operator()( const A & x ) const;
  };
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
