Enforces a maximum number of lines in inline template, styles and animations. See more at https://angular.io/guide/styleguide#style-05-04

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  template: `
            ~
    <div>first line</div>
    <div>second line</div>
    <div>third line</div>
    <div>fourth line</div>
  `
  ~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  template: '<div>first line</div>'
            ~~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  styles: [
          ~
    `
      div {
        display: block;
        height: 40px;
      }
    `
  ]
  ~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  styles: `
          ~
    div {
      display: block;
      height: 40px;
    }
  `
  ~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  styles: [
          ~
    `
      div {
        display: block;
      }
    `,
    `
      span {
        width: 30px;
      }
    `
  ]
  ~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  styles: ['div { display: none; }']
          ~~~~~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  animations: [{
              ~
    transformPanelWrap: trigger('transformPanelWrap', [
      transition('* => void', query('@transformPanel', [animateChild()], {optional: true})),
    ]),
    transformPanel: trigger('transformPanel', [
      state('void', style({
        transform: 'scaleY(0.8)',
        minWidth: '100%',
        opacity: 0
      })),
      state('showing', style({
        opacity: 1,
        minWidth: 'calc(100% + 32px)',
        transform: 'scaleY(1)'
      })),
      state('next', style({height: '0px', visibility: 'hidden'}))
    ])
  }]
   ~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  animations: [
              ~
    trigger('dialogContainer', [
      transition('* => void', query('@transformPanel', [animateChild()], {optional: true}))
    ]),
    trigger('transformPanel', [
      state('void', style({
        transform: 'scaleY(0.8)',
        minWidth: '100%',
        opacity: 0
      })),
      state('showing', style({
        opacity: 1,
        minWidth: 'calc(100% + 32px)',
        transform: 'scaleY(1)'
      }))
    ]),
    trigger('transformPanel', [
      state('void', style({opacity: 0, transform: 'scale(1, 0)'}))
    ])
  ]
  ~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  animations: [{
              ~
    transformPanel: trigger('transformPanel', [
      state('void', style({opacity: 0, transform: 'scale(1, 0)'}))
    ])
  }]
   ~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  template: '<div>just one line template</div>'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  styles: ['div { display: none; }']
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  styles: 'div { display: none; }'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  animations: [state('void', style({opacity: 0, transform: 'scale(1, 0)'}))]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  styleUrls: ['./foobar.scss'],
  templateUrl: './foobar.html',
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  animations: [
    state('void', style({opacity: 0, transform: 'scale(1, 0)'}))
  ],
  templateUrl: './foobar.html',
})
class Test {}
```

</details>
