[Accessibility] Enforces alternate text for elements which require the alt, aria-label, aria-labelledby attributes.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<ng-template>
  <div>
    <img src="foo">
    ~~~~~~~~~~~~~~~
  </div>
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<object></object>
~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<area />
~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input type="image">
~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [type]="'image'">
~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<img src="foo" alt="Foo eating a sandwich.">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="foo" [attr.alt]="altText">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="foo" [attr.alt]="'Alt Text'">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="foo" alt="">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object aria-label="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object aria-labelledby="id1">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object>Meaningful description</object>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object title="An object">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area aria-label="foo" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area aria-labelledby="id1" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area alt="This is descriptive!" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="image" alt="This is descriptive!">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="image" aria-label="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="image" aria-labelledby="id1">
```

</details>
