Makes sure that all pods have a unprivileged security context set.

# Details
Privileged containers have effectively the same permissions as `root` access on the host which are more capabilities than they usually need.
Considering the general security principle `Least Privileges`, the goal is to limit container’s capabilities to the bare minimum necessary to operate correctly.
Setting the `privileged` option to false where possible is the best practice and one step of creating a secure security context.

# Further Reading:
- Jim Bugwadia. 10 Kubernetes Best Practices You Can Easily Apply to Your Clusters. Nov. 14, 2019. url: https://thenewstack.io/10-kubernetes-best-practices-you-can-easily-apply-to-your-clusters/
- Brendan Burns et al. Kubernetes Best Practices. First Edition. Sebastopol: O’Reilly Media, Inc., 2019. isbn: 9781492056478.
- Liz Rice, ed. Running with Scissors. KubeCon. (May 2–4, 2018). Copenhagen, Denmark. url: https://kccnceu18.sched.com/event/EMyr/keynote-running-with-scissors-liz-rice-technology-evangelist-aqua-security-slides-attached
- Liz Rice and Michael Hausenblas. Kubernetes Security. First Edition. Sebastopol: O’Reilly Media, Inc., 2018. isbn: 9781492039068.
