<h2>Why is this an issue?</h2>
<p>Calling <a href="https://learn.microsoft.com/en-us/dotnet/api/system.object.tostring">ToString()</a> on an object should always return a
<code>string</code>. Thus, <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/how-to-override-the-tostring-method">overriding the
ToString method</a> should never return <code>null</code>, as it breaks the method’s implicit contract, and as a result the consumer’s
expectations.</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
public override string ToString ()
{
  if (this.collection.Count == 0)
  {
    return null; // Noncompliant
  }
  else
  {
    // ...
  }
}
</pre>
<p>A better alternative is to use the <a href="https://learn.microsoft.com/en-us/dotnet/api/system.string.empty">String.Empty</a> built-in field.</p>
<pre data-diff-id="1" data-diff-type="compliant">
public override string ToString ()
{
  if (this.collection.Count == 0)
  {
    return string.Empty;
  }
  else
  {
    // ...
  }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/476">CWE-476 - NULL Pointer Dereference</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.object.tostring">Object.ToString Method</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/how-to-override-the-tostring-method">How to
  override the ToString method</a> </li>
</ul>

