﻿## SA1121

<table>
<tr>
  <td>TypeName</td>
  <td>SA1121UseBuiltInTypeAlias</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1121</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The code uses one of the basic C# types, but does not use the built-in alias for the type.

## Rule description

A violation of this rule occurs when one of the following types are used anywhere in the code: *Boolean, Byte, Char, Decimal, Double, Int16, Int32, Int64, Object, SByte, Single, String, UInt16, UInt32, UInt64*.

A violation also occurs when any of these types are represented in the code using the full namespace for the type: *System.Boolean, System.Byte, System.Char, System.Decimal, System.Double, System.Int16, System.Int32, System.Int64, System.Object, System.SByte, System.Single, System.String, System.UInt16, System.UInt32, System.UInt64*.

Rather than using the type name or the fully-qualified type name, the built-in aliases for these types should always be used: *bool, byte, char, decimal, double, short, int, long, object, sbyte, float, string, ushort, uint, ulong*.

The following table lists each of these types in all three formats:

| Type Alias | Type | Fully Qualified Type |
| --- | --- | --- |
| bool | Boolean | System.Boolean |
| byte | Byte | System.Byte |
| char | Char | System.Char |
| decimal | Decimal | System.Decimal |
| double | Double | System.Double |
| short | Int16 | System.Int16 |
| int | Int32 | System.Int32 |
| long | Int64 | System.Int64 |
| object | Object | System.Object |
| sbyte | SByte | System.SByte |
| float | Single | System.Single |
| string | String | System.String |
| ushort | UInt16 | System.UInt16 |
| uint | UInt32 | System.UInt32 |
| ulong | UInt64 | System.UInt64 |

## How to fix violations

To fix a violation of this rule, replace the type with the built-in alias for the type.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1121:UseBuiltInTypeAlias", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1121 // UseBuiltInTypeAlias
#pragma warning restore SA1121 // UseBuiltInTypeAlias
```
