﻿## SA1123

<table>
<tr>
  <td>TypeName</td>
  <td>SA1123DoNotPlaceRegionsWithinElements</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1123</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The C# code contains a region within the body of a code element.

## Rule description

A violation of this rule occurs whenever a region is placed within the body of a code element. In many editors, including Visual Studio, the region will appear collapsed by default, hiding the code within the region. It is generally a bad practice to hide code within the body of an element, as this can lead to bad decisions as the code is maintained over time.

## How to fix violations

To fix a violation of this rule, remove the region from the code.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1123:DoNotPlaceRegionsWithinElements", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1123 // DoNotPlaceRegionsWithinElements
#pragma warning restore SA1123 // DoNotPlaceRegionsWithinElements
```
