﻿## SA1502

<table>
<tr>
  <td>TypeName</td>
  <td>SA1502ElementMustNotBeOnSingleLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1502</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

A C# element containing opening and closing braces is written completely on a single line.

## Rule description

A violation of this rule occurs when an element that is wrapped in opening and closing braces is written on a single line. For example:

```csharp
public object Method() { return null; }
```

When StyleCop checks this code, a violation of this rule will occur because the entire method is written on one line. The method should be written across multiple lines, with the opening and closing braces each on their own line, as follows:

```csharp
public object Method()
{
    return null; 
}
```

As an exception to this rule, accessors within properties, events, or indexers are allowed to be written all on a single line, as long as the accessor is short.

## How to fix violations

To fix a violation of this rule, rewrite the element so that it expands across multiple lines.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1502:ElementMustNotBeOnSingleLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1502 // ElementMustNotBeOnSingleLine
#pragma warning restore SA1502 // ElementMustNotBeOnSingleLine
```
