﻿## SA1626

<table>
<tr>
  <td>TypeName</td>
  <td>SA1626SingleLineCommentsMustNotUseDocumentationStyleSlashes</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1626</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The C# code contains a single-line comment which begins with three forward slashes in a row.

## Rule description

A violation of this rule occurs when the code contains a single-line comment which begins with three slashes. Comments beginning with three slashes are reserved for Xml documentation headers. Single-line comments should begin with only two slashes. When commenting out lines of code, it is advisable to begin the comment with four slashes to differentiate it from normal comments. For example:

```csharp
    /// <summary>
    /// Joins a first name and a last name together into a single string.
    /// </summary>
    /// <param name="firstName">Part of the name.</param>
    /// <param name="lastName">Part of the name.</param>
    /// <returns>The joined names.</returns>
    public string JoinNames(string firstName, string lastName)
    {
*A legal comment beginning with two slashes:*
        // Join the names together.
        string fullName = firstName + " " + lastName;

*An illegal comment beginning with three slashes:*
        /// Trim the name.
        fullName = fullName.Trim();

*A line of commented-out code beginning with four slashes:*
        ////fullName = asfd; 

        return fullName;
    }
```

## How to fix violations

To fix a violation of this rule, remove a slash from the beginning of the comment so that it begins with only two slashes.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1626:SingleLineCommentsMustNotUseDocumentationStyleSlashes", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1626 // SingleLineCommentsMustNotUseDocumentationStyleSlashes
#pragma warning restore SA1626 // SingleLineCommentsMustNotUseDocumentationStyleSlashes
```
