<h2>Why is this an issue?</h2>
<p>Well-named functions can allow the users of your code to understand at a glance what to expect from the function - even before reading the
documentation. Toward that end, methods returning a boolean should have names that start with "is" or "has" rather than with "get".</p>
<h3>Noncompliant code example</h3>

```java
public boolean getFoo() { // Noncompliant
  // ...
}

public boolean getBar(Bar c) { // Noncompliant
  // ...
}

public boolean testForBar(Bar c) { // Compliant - The method does not start by 'get'.
  // ...
}
```
<h3>Compliant solution</h3>

```java
public boolean isFoo() {
  // ...
}

public boolean hasBar(Bar c) {
  // ...
}

public boolean testForBar(Bar c) {
  // ...
}
```
<h3>Exceptions</h3>
<p>Overriding methods are excluded.</p>

```java
@Override
public boolean getFoo(){
  // ...
}
```