<h2>Why is this an issue?</h2>
<p>Passing a collection as an argument to the collection’s own method is either an error - some other argument was intended - or simply nonsensical
code.</p>
<p>Further, because some methods require that the argument remain unmodified during the execution, passing a collection to itself can result in
undefined behavior.</p>
<h3>Noncompliant code example</h3>

```java
List <Object> objs = new ArrayList<Object>();
objs.add("Hello");

objs.add(objs); // Noncompliant; StackOverflowException if objs.hashCode() called
objs.addAll(objs); // Noncompliant; behavior undefined
objs.containsAll(objs); // Noncompliant; always true
objs.removeAll(objs); // Noncompliant; confusing. Use clear() instead
objs.retainAll(objs); // Noncompliant; NOOP
```