<h2>Why is this an issue?</h2>
<p>Using the standard <code>getClassLoader()</code> may not return the <em>right</em> class loader in a JEE context. Instead, go through the
<code>currentThread</code>.</p>
<h3>Noncompliant code example</h3>

```java
ClassLoader cl = this.getClass().getClassLoader();  // Noncompliant
```
<h3>Compliant solution</h3>

```java
ClassLoader cl = Thread.currentThread().getContextClassLoader();
```