<h2>Why is this an issue?</h2>
<p>Stream operations are divided into intermediate and terminal operations, and are combined to form stream pipelines. After the terminal operation is
performed, the stream pipeline is considered consumed, and cannot be used again. Such a reuse will yield unexpected results.</p>
<h3>Noncompliant code example</h3>

```java
Stream<Widget> pipeline = widgets.stream().filter(b -> b.getColor() == RED);
int sum1 = pipeline.sum();
int sum2 = pipeline.mapToInt(b -> b.getWeight()).sum(); // Noncompliant
```
<h2>Resources</h2>
<p><a href="https://docs.oracle.com/javase/8/docs/api/java/util/stream/package-summary.html#StreamOps">Stream Operations</a></p>