<h2>Why is this an issue?</h2>
<p>When <code>if</code> is the only statement in the <code>else</code> block, it is better to use <code>else if</code> because it simplifies the code
and makes it more readable.</p>
<p>When using nested <code>if</code> statements, it can be difficult to keep track of the logic and understand the flow of the code. Using <code>else
if</code> makes the code more concise and easier to follow.</p>

```js
if (condition1) {
    // ...
} else {
    if (condition2) {  // Noncompliant: 'if' statement is the only statement in the 'else' block
        // ...
    }
}


if (condition3) {
    // ...
} else {
    if (condition4) { // Noncompliant: 'if' statement is the only statement in the 'else' block
        // ...
    } else {
        // ...
    }
}
```
<p>Fix your code by using <code>else if</code> if the nested <code>if</code> is the only statement in the <code>else</code> block.</p>

```js
if (condition1) {
    // ...
} else if (condition2) {
    // ...
}


if (condition3) {
    // ...
} else if (condition4) {
    // ...
} else {
    // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/if...else"><code>if...else</code></a>
  </li>
</ul>