<h2>Why is this an issue?</h2>
<p>The use of literals (primitive values such as strings, numbers, booleans, etc.) for promise rejection is generally discouraged. While it is
syntactically valid to provide literals as a rejected promise value, it is considered best practice to use instances of the Error class or its
subclasses instead.</p>
<p>Using an instance of the Error class allows you to provide more meaningful information about the error. The Error class and its subclasses provide
properties such as message and stack that can be used to convey useful details about the error, such as a description of the problem, the context in
which it occurred, or a stack trace for debugging.</p>

```js
new Promise(function(resolve, reject) {
  reject(); // Noncompliant: use Error object to provide rejection reason
});

new Promise(function(resolve, reject) {
  reject('Something went wrong'); // Noncompliant: use Error object instead of literal
});
```
<p>To fix your code provide an instanse of the Error class to the promise reject function.</p>

```js
new Promise(function(resolve, reject) {
  reject(new Error('Network timeout'));
});

new Promise(function(resolve, reject) {
  reject(new Error('Something went wrong'));
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise">Promise</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error">Error</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S3696'>javascript:S3696</a> - Literals should not be thrown </li>
</ul>