<h2>Why is this an issue?</h2>
<p>Defining and using global variables and global functions, when the convention dictates OOP can be confusing and difficult to use properly for
multiple reasons:</p>
<ul>
  <li> You run the risk of name clashes. </li>
  <li> Global functions must be stateless, or they can cause difficult-to-track bugs. </li>
  <li> Global variables can be updated from anywhere and may no longer hold the value you expect. </li>
  <li> It is difficult to properly test classes that use global functions. </li>
</ul>
<p>Instead of being declared globally, such variables and functions should be moved into a class, potentially marked <code>static</code>, so they can
be used without a class instance.</p>
<p>This rule checks that only object-oriented programming is used and that no functions or procedures are declared outside of a class.</p>
<h3>Noncompliant code example</h3>

```php
<?php

$name = "Bob"; // Noncompliant

function doSomething($arg) {   // Noncompliant
  //...
}

class MyClass {
    //...
}
```
<h3>Compliant solution</h3>

```php
<?php
class MyClass {

  public static $name = "Bob"; // Compliant

  public static function doSomething($arg) {              // Compliant
    //...
  }
  //...
}
```