<h2>Why is this an issue?</h2>
<p>In PHPUnit, to test that an exception is thrown in a given piece of code, the <em>expectException*()</em> methods or the
<em>@expectedException*</em> annotations can be used. For such a test to succeed, something in the test method has to throw an exception with the
awaited properties. Having an assertion at the end of such a test method, means that, if the test succeeds, that assertion was never evaluated because
an exception was thrown before getting to that point.</p>
<h3>Noncompliant code example</h3>

```php
public function testA() {
    $o = new MyClass();
    $this->expectException(\Exception::class);
    $o->doSomething();
    $this->assertTrue($o->hasProperty()); // Noncompliant - This assertion might never get evaluated
}
```
<h3>Compliant solution</h3>

```php
public function testA() {
    $o = new MyClass();
    $this->expectException(\Exception::class);
    $o->doSomething();
}

public function testB() {
    $o = new MyClass();
    $this->assertTrue($o->hasProperty());
}
```