<h2>Why is this an issue?</h2>
<p>Variable shadowing happens when a variable declared in a specific scope has the same name as a variable in an outer scope.</p>
<p>This can lead to three main problems:</p>
<ul>
  <li> Confusion: The same name can refer to different variables in different parts of the scope, making the code hard to read and understand. </li>
  <li> Unintended Behavior: You might accidentally use the wrong variable, leading to hard-to-detect bugs. </li>
  <li> Maintenance Issues: If the inner variable is removed or renamed, the code’s behavior might change unexpectedly because the outer variable is
  now being used. </li>
</ul>
<p>To avoid these problems, rename the shadowing, shadowed, or both variables to accurately represent their purpose with unique and meaningful
names.</p>
<p>Note that functions in JavaScript are first-class citizens. This means that they possess the same attributes as variables, including the ability to
shadow other variables and, conversely, be shadowed by them.</p>
<h3>Noncompliant code example</h3>
<p>The example below shows the typical situations in which shadowing can occur.</p>

```ts
function outer(items) {
  var counter = 0;

  function inner(items) { // Noncompliant: the parameter "items" is shadowed.
    var counter = counter + 1; // Noncompliant: the outer "counter" is shadowed.
  }

  inner(items);

  return counter; // returns 0
}

function search(items, match) { // Noncompliant: the function "match" (below) is shadowed.
  // ...
}

function match(value, key) {
  // ...
}
```
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S2814'>javascript:S2814</a> - Variables and functions should not be redeclared </li>
</ul>