<h2>Why is this an issue?</h2>
<p>Labels allow specifying a target statement to jump to using the <code>break</code> or <code>continue</code> statements. It’s possible to assign a
label to any statement or block of statements. However, using it with any statement can create a complex control flow path, making the code harder to
understand and maintain.</p>

```ts
myLabel: if (i % 2 == 0) { // Noncompliant: Labeling an if statement
  if (i == 12) {
    console.log("12");
    break myLabel;
  }
  console.log("Even number, but not 12");
}
```
<p>Instead of using a label with these nested <code>if</code> statements, this code block should be refactored.</p>

```ts
if (i % 2 == 0) { // Compliant
  if (i == 12) {
    console.log("12");
  } else {
    console.log("Even number, but not 12");
  }
}
```
<p>The rule considers that <code>while</code>, <code>do-while</code>, <code>for</code>, and <code>switch</code> statements don’t create complex
control flow paths, thus these statements are not reported.</p>

```ts
outerLoop: for (let i = 0; i < 10; i++) { // Compliant
  for (let j = 0; j < 10; j++) {
    if (condition(i, j)) {
      break outerLoop;
    }
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/label">label</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S1119'>javascript:S1119</a> - Labels should not be used </li>
</ul>