<h2>Why is this an issue?</h2>
<p>Test files in JavaScript and TypeScript are meant to contain test cases. These test cases are used to verify the functionality of your code and
ensure that it behaves as expected. If a test file doesn’t contain any test cases, it’s not serving its purpose.</p>
<p>A test file without test cases might indicate:</p>
<ul>
  <li> An incomplete test suite: Perhaps the developer started writing tests but didn’t finish. </li>
  <li> A mistake: The developer might have accidentally deleted the test cases or moved them to another file. </li>
</ul>
<p>This rule flags any file that has <code>.test</code> or <code>.spec</code> as part of its suffix but does not contain any test cases defined using
the different forms of the <code>it</code> and <code>test</code> functions from Jasmine, Jest, Mocha, or Node.js testing API.</p>
<h2>How to fix it</h2>
<p>Add test cases to the file or delete it if it isn’t needed anymore.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
// eval.test.js

/* no test cases */
```
<h4>Compliant solution</h4>

```ts
// eval.test.js

it('1 + 2 should give 3', () => {
    expect(1 + 2).toBe(3);
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Jasmine docs - <a href="https://jasmine.github.io/api/edge/global">API</a> </li>
  <li> Jest docs - <a href="https://jestjs.io/docs/api">API</a> </li>
  <li> Mocha docs - <a href="https://mochajs.org/#getting-started">API</a> </li>
  <li> Node.js docs - <a href="https://nodejs.org/api/test.html">API</a> </li>
</ul>