Do not put multiple statements in a lambda and avoid using nested lambda expressions.
If multiple statements or nested lambda expressions are needed inside a lambda expression, you should extract a method.

# What Does This Check Look For?

This check searches for code that includes multiple statements in lambda that exceed the configured maximum length and optionally for nested lambda expressions.

# Why is This a Problem?

Adding multiple statements and using nested lambda expressions make the code more complex, make debugging harder, and can decrease readability.

# How Can I Resolve This?

If multiple statements are needed inside a lambda expression or nested lambdas are needed, you can create a method for these.

# Examples
## Non-Compliant

```java
// lambda with multiple statements
collection.stream().map(x -> {
	Foo foo = doSomething(x);
	...
	return foo;
}).collect(Collectors.toList());

// nested lambdas
a.b(c -> c.d(e -> e.f()));

```

## Compliant

```java
// convenient way for lambda with multiple statements
collection.stream().map(this::convertToFoo).collect(Collectors.toList());

// convinient way for nested lambdas
numbers.forEach( (a) -> a.b(foo(c)) );
```
