The `class` or `enum` in question is presumably thread-safe but this is not documented.
Add documentation about thread-safety to the `class` or `enum`.

# What Does This Check Look For?

This check looks for indications that thread-safety is intended. It checks for imports of classes in `java.util.concurrent`, thread-safety related words in comments, and `synchronized` or `volatile` keywords.

# Why is This a Problem?

Even though the implementation suggests that the class is intended to be thread-safe, as exhibited by the use of `synchronized` methods, `volatile` fields or the uses of classes from the `java.util.concurrent.*` (sub)packages, this is not readily apparent to clients;
the class's Javadoc does not mention this fact.

# How Can I Resolve This?

Provide class-level Javadoc that explains under which circumstances this `class` or `enum` may be used concurrently.

# Where Can I Learn More?

- [Code Review Checklist (Java Concurrency): Item Dc.1](https://github.com/code-review-checklists/java-concurrency#justify-document)
